# Events #

Events allow you to perform actions when text matching a pattern is received. You can do numerous things - change the colour of the text, omit it from the display or from log files, or spawn it to a separate window. You can also send text back to the MU\* (including running [/commands](SlashCommands) or [Macros](Macros)), or place a string of text in the input window.

Each world has its own set of Events, and there are also Global Events which are matched after World Events. They can be configured via the **Options...** menu, by selecting either **Configure Events** or **Global Events**.

![https://github.com/talvo/potato/wiki/Events.gif](https://github.com/talvo/potato/wiki/Events.gif)

The fields are:
  * **Pattern**: The pattern to match.
  * **Type**: The pattern type; one of Wildcard (glob matching), Regexp (regular expression match), or Contains (literal substring matching).
  * **Case?**: Match the pattern case-sensitively?
  * **Enabled?**: Is this Event enabled? Must be ticked to use this Event.
  * **Continue?**: If this Event matches, should we continue matching further events?
  * **Match All?**: Should all instances of the pattern in each line be matched, rather than just the first?
  * **Run When**: When this event can be matched. One of:
    * Always:
    * Not Up:
    * No Focus:
    * Inactive:
  * **Change FG**: Whether to recolour the text, and to what colour
  * **Change BG**: Whether to recolour the background of the text, and to what colour
  * **Omit From**: Do not print this text to
    * Display: The main output window
    * Log: Any log files
    * Activity: Suppresses taskbar and system tray flashing, and 'Activity in World' messages, for this event
  * **Spawn?**: Should we spawn this text? Must be ticked to enable spawning.
    * To: The name of the spawn window to use.
  * **Replace?**: Should we replace the matching portion(s) of the text?
    * With: Text to replace the matching portion(s) of the text with
  * **Send**: Text to send to the MU\*. Multiple lines can be entered, and will be sent separately. Can include [/commands](SlashCommands).
  * **Input**: Enter text to place into an input window, and select which input window to use. Can be "One" for the top input, "Two" for the bottom, or "Focus" for the one which currently has focus.

You can run [/commands](SlashCommands) in the Spawn, Replace, Send and Input fields; Potato will use the result of the command as the value for that field. Just wrap the value in `[`square brackets`]` - see below for examples.

For wildcard patterns, the first ten wildcards (\* for 0 or more chars, ? for exactly one char) are captured into the [variables](Variables) 0 - 9, which can be accessed in the Spawn, Replace, Send Input fields with the [/get](SlashCommands) command. For regexp patterns, the first 10 subexpressions (in parenthesis) are captured into the variables.

Some common examples are:
  * [Spawning Channel text](#Spawn_Channels)
  * [Add Timestamps to Chat Messages](#Timestamp_Channels)
  * [Spawning Pages](#Spawn_Pages)
  * [Omitting OOC speech from logs](#Omit_OOC_Speech_From_Logs)
  * [Recolouring Puppet output](#Recolour_Puppets)
  * [Automatically greeting new players](#Newbie_Greeter)

For all of these examples, "Enabled" is ticked and "Continue" is not. Nothing else is selected, unless otherwise stated.

### Spawn Channels ###
  * **Pattern**: `<*> *`
  * **Type**: Wildcard
  * **Spawn**: Ticked.
    * To: Use `channels` to spawn all channels into a single spawn window, or use `[/get 0]` to spawn each to its own, individual spawn window.

### Timestamp Channels ###
  * **Pattern**: `^(<.+?>) (.+)$`
  * **Type**: Regexp
  * **Replace?:** Ticked
    * With: `[[/get 0] [/time %T] [/get 1]]`

### Spawn Pages ###
  * **Pattern**: `^(From afar|Long distance to|\S.{1,20} pages|You paged .+? with).*$`
  * **Type**: Regexp
  * **Spawn**: Ticked.
    * To: `pages`

Tip: You can also alter the pattern so that pages to/from particular people go to a separate window.

### Omit OOC Speech From Logs ###
  * **Pattern**: `[OOC] *`
  * **Type**: Wildcard
  * **Omit From**: Log

### Recolour Puppets ###
  * **Pattern**: `My Puppet> *`
  * **Type**: Wildcard
  * **Change FG**: Green (or the colour of your choice)

### Newbie Greeter ###
  * **Pattern**: `<Newbie> * has joined the MUSH!`
  * **Type**: Wildcard
  * **Send**: `[+newbie Welcome, [/get 0]!]`

### Praise Me ###
  * **Pattern**: Mike
  * **Type**: Regexp
  * **Change FG**: Red Highlight
  * **Replace?:** Ticked
  * **Replace With:** Our Glorious Overlord

Thanks to Null, who suggested this feature and provided the example ;)
