# Running Potato from Source #

The simplest way to run Potato is using a [binary](Downloads), which contains the Potato source and a Tcl interpreter in a single file. However, if you don't wish to do this (either because a binay is not available for your platform, because you already have Tcl installed on your system, or because you wish to make changes to the source), you can run Potato from source. There are three ways to do this:

  * Download the [source code](Downloads)
  * Clone from GIT
  * Download the [Starkit](Downloads), a single-file archive of the Potato source code. Not suitable if you want to modify the Potato code!

All of these methods require that you have [Tcl installed](GettingTcl).


---


# Instructions #

## Windows ##
### Source ###
Extract the Potato.zip file into your C:\ drive - it contains a folder called potato.vfs. Download the [TclKit](GettingTcl) into the potato.vfs directory, and then drag-and-drop the file "main.tcl" onto the TclKit.exe to run.

### Starkit ###
If you're using a Starkit, make a folder (for instance, **C:\Potato**) and place the [Potato Starkit](Downloads#Source) in it. Download the [TclKit](GettingTcl) into the same directory, and drag-and-drop the Potato.kit file onto the TclKit.exe to run.

### GIT ###
Check out the potato.vfs folder from GIT. If you're using a command-line GIT client, the command is
```
git clone https://github.com/talvo/potato.git potato
```
You'll need to perform a second GIT clone to get the helpfiles:
```
git clone https://github.com/talvo/potato.wiki.git potato/potato.vfs/lib/help
```

Install [Tcl](GettingTcl) if you haven't already done so, and then double-click the file "main.tcl" to run.

## Linux and MacOS X ##
### Source ###
[Install Tcl and Tk](GettingTcl) if you haven't yet, extract the potato.tar.gz file into the directory of your choice drive - it contains a folder called potato.vfs. cd into the potato.vfs directory, then run main.tcl to start.
```
tar zxf potato*.tar.gz
cd potato.vfs
./main.tcl
```

### Starkit ###
Download the starkit into a folder of your choice, then run
```
tclsh potato.kit
```
(using the correct name for your version).

If you're using your system Tcl install, it's recommended you use the Potato source .zip instead of the Starkit, as there may be other dependencies.

### GIT ###
Check out the potato.vfs folder from GIT:
```
git clone https://github.com/talvo/potato.git potato
```
You'll need to perform a second GIT clone to get the helpfiles:
```
git clone https://github.com/talvo/potato.wiki.git potato/potato.vfs/lib/help
```
Then, to launch Potato, `cd` into potato/potato.vfs and use
```
./main.tcl &
```