# /commands #

A "/command" is a special command you can type into the input box (or anywhere else that sends text to the MU\*, like [Auto-Sends](ConfigureWorldsAutoSends)), as well as a few other places like [Event fields](Events). Rather than being sent to the MU\*, the command will be executed by Potato. (If you want to send something to the game beginning with a /, use two, like "//foo".)

Some /commands return a value, and /commands can be nested in each other, using the syntax
```
/command Text with the result of [/another-command] in it.
```
More examples are at the end.

The following is a list of available commands, with terse descriptions:

  * `/addspawn <spawn>` - Start spawning all output for this connection (regardless of events) to the specified spawn window.
  * `/all <string>` - Send `<string>` to all open connections.
  * `/at <time>=<command>` - At `<time>`, send the command `<command>` to the MU\*. See detailed help for [/at](SlashCommandsAt) for more information. Returns a unique ID that can be used with `/cancelat` to cancel it later.
  * `/cancelat <id>` - Cancel the specified [/at](SlashCommandsAt).
  * `/close` - Close the current connection.
  * `/cls [<conn>[.<window>]]` - Clear the screen for the specified connection, or the current connection if one isn't given. If a `<window>` is given, it clears that spawn window instead.
  * `/connect <address>` - Connect to an address. Can be either the name of a defined world from the Address Book, a `host:port` string or a `host port` string.
  * `/debug` - Toggle Debug Packets on and off.
  * `/delspawn <spawn>` - Stop spawning all output (started via `/addspawn`) to the specified spawn window.
  * `/disconnect` - Disconnect the current connection.
  * `/edit` - Edit the settings for the current world (or the program settings, if no connections are open).
  * `/eval <tcl code>` - Evaluates the given <tcl code>, and returns the result.
  * `/exit` - Exit Potato.
  * `/get [-all|-global|-local] <varname>` - Return the value of a variable set with `/set` or `/setglobal`. As well as a variable name, `<varname>` can also be one of `_u`, `_c`, `_w`, `_name`, `_char`, `_host` or `_port`, to return the number of the currently-displayed connection, the number of the connection the /get is running for, the world number of the connection /get is running for, the name of the world, the char connected, the host or the port, respectively.
  * `/history [<number>]` - With no arg, open the Input History window. With an arg, place the `<number>`th entry from the history into the input window. `<number>` can be negative, to count from the end instead of the start.
  * `/input <num> <string>` - Print `<string>` into the `<num>`th input window. `<num>` can be 1 for the top input, 2 for the bottom, or 3 for the one which currently has focus.
  * `/limit` - Filters output. See the help for [/limit](SlashCommandsLimit) for more details.
  * `/log` - Start or stop logging. See the help for [/log](Logging#/log) for more details.
  * `/null [<args>]` - Does nothing and returns nothing. Useful for eating the output of other /commands.
  * `/prompt [<prompt>]` - Set the prompt for this connection to `<prompt>`, or clear the current prompt if no `<prompt>` is given. It's not currently possible to set prompts containing ANSI with this command.
  * `/print <message>` - Print `<message>` as a system message.
  * `/quick <address>` - Perform a [quick connect](QuickConnect) to `<address>`, which is either a `host:port` or `host port` string.
  * `/reconnect` - Reconnect the current connection.
  * `/reload` - Reloads the main Potato source file, and the [potato.custom](CustomFile) file.
  * `/rename [<name>]` - Set a temporary name for the current connection, or clear the existing temporary name. Useful if you connect to one world multiple times, to make them easier to distinguish.
  * `/runmacro <macro>` - Run the given `<macro>`.
  * `/send <string>` - Send `<string>` to the current connection. Allows for nesting other /commands in `<string>`.
  * `/set <varname>=<value>` - Set a variable for the current connection.
  * `/setglobal <varname>=<value>` - Set a variable for all connections.
  * `/setprefix [<window>=][<prefix>]` - Set a prefix for the output window `<window>` or for the current output window if no `<window>` is given. If no `<prefix>` is given, clears the current prefix.
  * `/show <number>` - Show connection number `<number>`.
  * `/show [<number>.]<window>` - Show output window `<window>` for connection number `<number>`, or the current connection if `<number>` is omitted.
  * `/silent [<args>]` - Historical alias for `/null`.
  * `/slash` - Show a list of the available /commands.
  * `/speedwalk <dir> [<dir> ... <dir>]` - Send a number of movement commands to the current connection, as specified by the list of `<dir>`s. Each direction should be one of **N**, **S**, **E**, **W**, **NW**, **NE**, **SE**, **SW**, **U**, **D** or **O** (for cardinal directions, 'Up', 'Down' and 'Out'), possibly prefixed by a number, to repeat it that many times. For instance, `/speedwalk 3n o 2sw` would send `north`, `north`, `north`, `out`, `southwest`, `southwest`.
  * `/tcl` - On Windows, this command will open a Tcl Command console where Tcl code can be entered.
  * `/time [<format>]` - Returns the current time. If `<format>` is specified, the time will be formatted in a specific way; see [Clock Format Codes](ClockFormatCodes) for the possible formats.
  * `/tinyurl <url>` - Returns a shorter version of `<url>` and display it, using the configured TinyURL provider.
  * `/tinyurl <string>` - Replace each URL in `<string>` with a shortended version, using the configured TinyURL provider, and send the resulting string to the current connection (returns nothing).
  * `/toggle [<direction>]` - Toggle to the next connection. If `<direction>` is "down" or "-1", toggle backwards to the previous connection instead.
  * `/unlimit` - Stop filtering output. See [/limit](SlashCommandsLimit) for more details.
  * `/unset <varname>` - Unset a connection-specific variable created by `/set`.
  * `/unsetglobal <varname>` - Unset a global variable created by `/setglobal`.
  * `/vars` - Show all variables available to this connection set with `/set` and `/setglobal`.
  * `/web <url>` - Launch a web browser to the given URL.
  * `/world` - Alias for `/show`.
  * `/w` - Alias for `/show`.

Examples:
Set a macro to run in 25 minutes, saving the timer ID in a variable so it can be cancelled later.
```
/set my_timer=[/at 25 minutes=/runmacro mymacro]
```

Send text to the MU\*, including the value of some variables:
```
/send say I am connected to [/get _name] as [/get _char]
```