# Translating Potato #

If you're interested in translating Potato into another language, or would like to update an existing translation, please [contact me](ContactMe) and let me know which language (just in case someone else is already working on a translation in that language, to avoid duplicated efforts).

When you're ready to start, download the [Translation Template file](http://potatomushclient.googlecode.com/svn/trunk/potato.vfs/tools/potato-template.txt) from the Potato GIT repo.
## File Format ##

The template file is in the format:

```
# potato.tcl, line 11788  (::potato::tasksInit)
Close &All Logs
-

# potato.tcl, line 6838  (::potato::history), potato.tcl, line 7917  (::potato::keyboardShortcutWin)
Command
-

# potato.tcl, line 10127  (::potato::customSlashCommand)
Command will run at %s, id %s
-
```

The first line is a comment telling you where in the Potato source the message appears. The next line has the English (British) version of the message, and the third line is the translated message. Any translation which is a single hyphen is ignored, so you don't have to translate the messages in order, and don't have to translate all the messages for the translation to be used.

It may be difficult to translate some words or phrases literally - for example, several people have reported issues translating the world _Spawns_ literally. In this case, you can either leave the word/phrase in English, or use a non-literal translation with a similar meaning (for instance, _Spawns_ may be translated as _Popup Window_).

Some messages contain `&` symbols. These messages are used in menus, and the `&` indicates that the following letter should be underlined, and used for keyboard navigation in the menu. You can put the `&` anywhere in the translated message you feel is best, it doesn't need to be on the same letter.

Other messages contain `%s` or `%d`. These are substitutions, where other pieces of text will be substituted. If you need to change the order they appear in because the sentence structure is different in the translated message, you can use `%1$s` to refer to the first `%s` in the original message, `%2$s` to refer to the second, and so on. For example,

```
# potato.tcl, line 10127  (::potato::customSlashCommand)
Command will run at %s, id %s
Command id %1$s will run at %2$s
```

The translation file should be saved with a utf-8 encoding, or as plain 7-bit ascii. Accents can be typed directly if saving as utf-8. For ascii files, they must be encoded in the format:
```
\uXXXX
```

where `XXXX` is the 4-digit hex code representing the character. This can be found by entering the following command into Potato:

```
/eval format \\\\u%04x \[scan é %c\]
```

The filename should be the code for the language, with a `.ptf` extension. For example, `es.ptf` for Spanish, `en_gb.ptf` for British English, and so on.

## Testing the Translations ##
Potato's translation files are in the directory `potato.vfs/lib/i18n`. However, if you can't access the directory (because you're running a binary copy of Potato), or you don't want to replace an existing translation file while you test, you can create a local `i18n` directory and place your `.ptf` files in there. Where you create the directory depends on how you're running Potato:

  * When running with the --local command line option, create `i18n` in the same directory as your Potato executable or potato.vfs directory
  * On Windows, it should be in the same directory as the potato.exe when running from a binary, or the same directory as your potato.vfs directory when running from source.
  * On Linux, it should be created in `~/.potato/`

You will need to restart Potato for the new file to be noticed.