
#: proc ::potato::unicode-to-latin1
#: desc Convert a list of unicode characters to sane latin1 (iso8859-1) alternatives. Charmap from Brazil/TinyMUX.
#: arg str
#: return Modified $str with certain chars replaced.
proc ::potato::unicode-to-latin1 {str} {
  variable enc;

  return [string map $enc(unicode_to_latin1) $str];
};# ::potato::unicode-to-latin1

#: proc ::potato::unicode-to-latin1_init
#: desc Initialize the array of unicode to Latin1 char conversions
#: return nothing
proc ::potato::unicode-to-latin1_init {} {
  variable enc;
  set unicode_to_latin1 [list \
    \u0007 7 \u0008 8 \u0009 9 \u000A 10 \u000D 13 \u001B 27 \u0020 32 \u0021 33 \u0022 34 \u0023 35  \
    \u0024 36 \u0025 37 \u0026 38 \u0027 39 \u0028 40 \u0029 41 \u002A 42 \u002B 43 \u002C 44 \u002D 45  \
    \u002E 46 \u002F 47 \u0030 48 \u0031 49 \u0032 50 \u0033 51 \u0034 52 \u0035 53 \u0036 54 \u0037 55  \
    \u0038 56 \u0039 57 \u003A 58 \u003B 59 \u003C 60 \u003D 61 \u003E 62 \u003F 63 \u0040 64 \u0041 65  \
    \u0042 66 \u0043 67 \u0044 68 \u0045 69 \u0046 70 \u0047 71 \u0048 72 \u0049 73 \u004A 74 \u004B 75  \
    \u004C 76 \u004D 77 \u004E 78 \u004F 79 \u0050 80 \u0051 81 \u0052 82 \u0053 83 \u0054 84 \u0055 85  \
    \u0056 86 \u0057 87 \u0058 88 \u0059 89 \u005A 90 \u005B 91 \u005C 92 \u005D 93 \u005E 94 \u005F 95  \
    \u0060 96 \u0061 97 \u0062 98 \u0063 99 \u0064 100 \u0065 101 \u0066 102 \u0067 103 \u0068 104 \u0069 105  \
    \u006A 106 \u006B 107 \u006C 108 \u006D 109 \u006E 110 \u006F 111 \u0070 112 \u0071 113 \u0072 114 \u0073 115  \
    \u0074 116 \u0075 117 \u0076 118 \u0077 119 \u0078 120 \u0079 121 \u007A 122 \u007B 123 \u007C 124 \u007D 125  \
    \u007E 126 \u00A0 160 \u00A1 161 \u00A2 162 \u00A3 163 \u00A4 164 \u00A5 165 \u00A6 166 \u00A7 167 \u00A8 168  \
    \u00A9 169 \u00AA 170 \u00AB 171 \u00AC 172 \u00AD 173 \u00AE 174 \u00AF 175 \u00B0 176 \u00B1 177 \u00B2 178  \
    \u00B3 179 \u00B4 180 \u00B5 181 \u00B6 182 \u00B7 183 \u00B8 184 \u00B9 185 \u00BA 186 \u00BB 187 \u00BC 188  \
    \u00BD 189 \u00BE 190 \u00BF 191 \u00C0 192 \u00C1 193 \u00C2 194 \u00C3 195 \u00C4 196 \u00C5 197 \u00C6 198  \
    \u00C7 199 \u00C8 200 \u00C9 201 \u00CA 202 \u00CB 203 \u00CC 204 \u00CD 205 \u00CE 206 \u00CF 207 \u00D0 208  \
    \u00D1 209 \u00D2 210 \u00D3 211 \u00D4 212 \u00D5 213 \u00D6 214 \u00D7 215 \u00D8 216 \u00D9 217 \u00DA 218  \
    \u00DB 219 \u00DC 220 \u00DD 221 \u00DE 222 \u00DF 223 \u00E0 224 \u00E1 225 \u00E2 226 \u00E3 227 \u00E4 228  \
    \u00E5 229 \u00E6 230 \u00E7 231 \u00E8 232 \u00E9 233 \u00EA 234 \u00EB 235 \u00EC 236 \u00ED 237 \u00EE 238  \
    \u00EF 239 \u00F0 240 \u00F1 241 \u00F2 242 \u00F3 243 \u00F4 244 \u00F5 245 \u00F6 246 \u00F7 247 \u00F8 248  \
    \u00F9 249 \u00FA 250 \u00FB 251 \u00FC 252 \u00FD 253 \u00FE 254 \u00FF 255 \u0100 65 \u0101 97 \u0102 65  \
    \u0103 97 \u0104 65 \u0105 97 \u0106 67 \u0107 99 \u0108 67 \u0109 99 \u010A 67 \u010B 99 \u010C 67  \
    \u010D 99 \u010E 68 \u010F 100 \u0110 68 \u0111 100 \u0112 69 \u0113 101 \u0114 69 \u0115 101 \u0116 69  \
    \u0117 101 \u0118 69 \u0119 101 \u011A 69 \u011B 101 \u011C 71 \u011D 103 \u011E 71 \u011F 103 \u0120 71  \
    \u0121 103 \u0122 71 \u0123 103 \u0124 72 \u0125 104 \u0126 72 \u0127 104 \u0128 73 \u0129 105 \u012A 73  \
    \u012B 105 \u012C 73 \u012D 105 \u012E 73 \u012F 105 \u0130 73 \u0134 74 \u0135 106 \u0136 75 \u0137 107  \
    \u0139 76 \u013A 108 \u013B 76 \u013C 108 \u013D 76 \u013E 108 \u013F 76 \u0140 108 \u0141 76 \u0142 108  \
    \u0143 78 \u0144 110 \u0145 78 \u0146 110 \u0147 78 \u0148 110 \u0149 110 \u014C 79 \u014D 111 \u014E 79  \
    \u014F 111 \u0150 79 \u0151 111 \u0154 82 \u0155 114 \u0156 82 \u0157 114 \u0158 82 \u0159 114 \u015A 83  \
    \u015B 115 \u015C 83 \u015D 115 \u015E 83 \u015F 115 \u0160 83 \u0161 115 \u0162 84 \u0163 116 \u0164 84  \
    \u0165 116 \u0166 84 \u0167 116 \u0168 85 \u0169 117 \u016A 85 \u016B 117 \u016C 85 \u016D 117 \u016E 85  \
    \u016F 117 \u0170 85 \u0171 117 \u0172 85 \u0173 117 \u0174 87 \u0175 119 \u0176 89 \u0177 121 \u0178 255  \
    \u0179 90 \u017A 122 \u017B 90 \u017C 122 \u017D 122 \u017E 122 \u017F 115 \u0180 98 \u0181 66 \u0182 66  \
    \u0183 98 \u0187 67 \u0188 99 \u018A 68 \u018B 68 \u018C 100 \u0191 70 \u0192 102 \u0193 71 \u0197 73  \
    \u0198 75 \u0199 107 \u019A 108 \u019D 78 \u019E 110 \u019F 79 \u01A0 79 \u01A1 111 \u01A4 80 \u01A5 112  \
    \u01AB 116 \u01AC 84 \u01AD 116 \u01AE 84 \u01AF 85 \u01B0 117 \u01B2 86 \u01B3 89 \u01B4 121 \u01B5 90  \
    \u01B6 122 \u01C3 33 \u01CD 65 \u01CE 97 \u01CF 73 \u01D0 105 \u01D1 79 \u01D2 111 \u01D3 85 \u01D4 117  \
    \u01D5 85 \u01D6 117 \u01D7 85 \u01D8 117 \u01D9 85 \u01DA 117 \u01DB 85 \u01DC 117 \u01DE 65 \u01DF 97  \
    \u01E0 65 \u01E1 97 \u01E3 230 \u01E4 71 \u01E5 103 \u01E6 71 \u01E7 103 \u01E8 75 \u01E9 107 \u01EA 79  \
    \u01EB 111 \u01EC 79 \u01ED 111 \u01F0 106 \u01F4 71 \u01F5 103 \u01F8 78 \u01F9 110 \u01FA 65 \u01FB 97  \
    \u01FD 230 \u01FE 79 \u01FF 111 \u0200 65 \u0201 97 \u0202 65 \u0203 97 \u0204 69 \u0205 101 \u0206 69  \
    \u0207 101 \u0208 73 \u0209 105 \u020A 73 \u020B 105 \u020C 79 \u020D 111 \u020E 79 \u020F 111 \u0210 82  \
    \u0211 114 \u0212 82 \u0213 114 \u0214 85 \u0215 117 \u0216 85 \u0217 117 \u0218 83 \u0219 115 \u021A 84  \
    \u021B 116 \u021E 72 \u021F 104 \u0220 78 \u0221 100 \u0224 90 \u0225 122 \u0226 65 \u0227 97 \u0228 69  \
    \u0229 101 \u022A 79 \u022B 111 \u022C 79 \u022D 111 \u022E 79 \u022F 111 \u0230 79 \u0231 111 \u0232 89  \
    \u0233 121 \u0234 108 \u0235 110 \u0236 116 \u023A 65 \u023B 67 \u023C 99 \u023D 76 \u023E 84 \u023F 115  \
    \u0240 122 \u0243 66 \u0244 85 \u0246 69 \u0247 101 \u0248 74 \u0249 106 \u024B 113 \u024C 82 \u024D 114  \
    \u024E 89 \u024F 121 \u0253 98 \u0255 99 \u0256 100 \u0257 100 \u0260 103 \u0266 104 \u0268 105 \u026B 108  \
    \u026C 108 \u026D 108 \u026E 108 \u0271 109 \u0272 110 \u0273 110 \u027C 114 \u027D 114 \u027E 114 \u0282 115  \
    \u0288 116 \u0289 117 \u028B 118 \u0290 122 \u0291 122 \u029D 106 \u02A0 113 \u02B0 104 \u02B2 106 \u02B3 114  \
    \u02B7 119 \u02B8 121 \u02D8 32 \u02D9 32 \u02DA 32 \u02DB 32 \u02DC 126 \u02DD 32 \u02E1 108 \u02E2 115  \
    \u02E3 120 \u037A 32 \u037E 59 \u0384 32 \u0385 32 \u0404 69 \u0406 73 \u040D 73 \u0410 65 \u0418 73  \
    \u041E 79 \u0423 85 \u042D 69 \u0430 97 \u0438 105 \u043E 111 \u0443 117 \u044D 101 \u0454 101 \u0456 105  \
    \u045D 105 \u04A8 79 \u04A9 111 \u04BA 72 \u04BB 104 \u04D0 65 \u04D1 97 \u04D2 65 \u04D3 97 \u04E2 73  \
    \u04E3 105 \u04E4 73 \u04E5 105 \u04E6 79 \u04E7 111 \u04EC 69 \u04ED 101 \u04EE 85 \u04EF 117 \u04F0 85  \
    \u04F1 117 \u04F2 85 \u04F3 117 \u055C 33 \u055E 63 \u058A 45 \u061F 63 \u0660 48 \u0661 49 \u0662 50  \
    \u0663 51 \u0664 52 \u0665 53 \u0666 54 \u0667 55 \u0668 56 \u0669 57 \u06F0 48 \u06F1 49 \u06F2 50  \
    \u06F3 51 \u06F4 52 \u06F5 53 \u06F6 54 \u06F7 55 \u06F8 56 \u06F9 57 \u07C0 48 \u07C1 49 \u07C2 50  \
    \u07C3 51 \u07C4 52 \u07C5 53 \u07C6 54 \u07C7 55 \u07C8 56 \u07C9 57 \u07F9 33 \u0966 48 \u0967 49  \
    \u0968 50 \u0969 51 \u096A 52 \u096B 53 \u096C 54 \u096D 55 \u096E 56 \u096F 57 \u09E6 48 \u09E7 49  \
    \u09E8 50 \u09E9 51 \u09EA 52 \u09EB 53 \u09EC 54 \u09ED 55 \u09EE 56 \u09EF 57 \u0A66 48 \u0A67 49  \
    \u0A68 50 \u0A69 51 \u0A6A 52 \u0A6B 53 \u0A6C 54 \u0A6D 55 \u0A6E 56 \u0A6F 57 \u0AE6 48 \u0AE7 49  \
    \u0AE8 50 \u0AE9 51 \u0AEA 52 \u0AEB 53 \u0AEC 54 \u0AED 55 \u0AEE 56 \u0AEF 57 \u0B66 48 \u0B67 49  \
    \u0B68 50 \u0B69 51 \u0B6A 52 \u0B6B 53 \u0B6C 54 \u0B6D 55 \u0B6E 56 \u0B6F 57 \u0BE6 48 \u0BE7 49  \
    \u0BE8 50 \u0BE9 51 \u0BEA 52 \u0BEB 53 \u0BEC 54 \u0BED 55 \u0BEE 56 \u0BEF 57 \u0C66 48 \u0C67 49  \
    \u0C68 50 \u0C69 51 \u0C6A 52 \u0C6B 53 \u0C6C 54 \u0C6D 55 \u0C6E 56 \u0C6F 57 \u0CE6 48 \u0CE7 49  \
    \u0CE8 50 \u0CE9 51 \u0CEA 52 \u0CEB 53 \u0CEC 54 \u0CED 55 \u0CEE 56 \u0CEF 57 \u0D66 48 \u0D67 49  \
    \u0D68 50 \u0D69 51 \u0D6A 52 \u0D6B 53 \u0D6C 54 \u0D6D 55 \u0D6E 56 \u0D6F 57 \u0E50 48 \u0E51 49  \
    \u0E52 50 \u0E53 51 \u0E54 52 \u0E55 53 \u0E56 54 \u0E57 55 \u0E58 56 \u0E59 57 \u0ED0 48 \u0ED1 49  \
    \u0ED2 50 \u0ED3 51 \u0ED4 52 \u0ED5 53 \u0ED6 54 \u0ED7 55 \u0ED8 56 \u0ED9 57 \u0F20 48 \u0F21 49  \
    \u0F22 50 \u0F23 51 \u0F24 52 \u0F25 53 \u0F26 54 \u0F27 55 \u0F28 56 \u0F29 57 \u1040 48 \u1041 49  \
    \u1042 50 \u1043 51 \u1044 52 \u1045 53 \u1046 54 \u1047 55 \u1048 56 \u1049 57 \u1367 63 \u1369 49  \
    \u136A 50 \u136B 51 \u136C 52 \u136D 53 \u136E 54 \u136F 55 \u1370 56 \u1371 57 \u17E0 48 \u17E1 49  \
    \u17E2 50 \u17E3 51 \u17E4 52 \u17E5 53 \u17E6 54 \u17E7 55 \u17E8 56 \u17E9 57 \u1806 173 \u1810 48  \
    \u1811 49 \u1812 50 \u1813 51 \u1814 52 \u1815 53 \u1816 54 \u1817 55 \u1818 56 \u1819 57 \u1944 33  \
    \u1945 63 \u1946 48 \u1947 49 \u1948 50 \u1949 51 \u194A 52 \u194B 53 \u194C 54 \u194D 55 \u194E 56  \
    \u194F 57 \u19D0 48 \u19D1 49 \u19D2 50 \u19D3 51 \u19D4 52 \u19D5 53 \u19D6 54 \u19D7 55 \u19D8 56  \
    \u19D9 57 \u1B50 48 \u1B51 49 \u1B52 50 \u1B53 51 \u1B54 52 \u1B55 53 \u1B56 54 \u1B57 55 \u1B58 56  \
    \u1B59 57 \u1D00 65 \u1D03 66 \u1D04 67 \u1D05 68 \u1D06 100 \u1D07 69 \u1D08 69 \u1D09 73 \u1D0A 74  \
    \u1D0B 75 \u1D0C 76 \u1D0D 77 \u1D0E 78 \u1D0F 79 \u1D10 79 \u1D11 79 \u1D12 79 \u1D13 79 \u1D16 79  \
    \u1D17 79 \u1D18 80 \u1D19 82 \u1D1A 82 \u1D1B 84 \u1D1C 85 \u1D1D 85 \u1D1E 85 \u1D1F 77 \u1D20 86  \
    \u1D21 87 \u1D22 90 \u1D2C 65 \u1D2E 66 \u1D30 68 \u1D31 69 \u1D33 71 \u1D34 72 \u1D35 73 \u1D36 74  \
    \u1D37 75 \u1D38 76 \u1D39 77 \u1D3A 78 \u1D3C 79 \u1D3E 80 \u1D3F 82 \u1D40 84 \u1D41 85 \u1D42 87  \
    \u1D43 97 \u1D47 98 \u1D48 100 \u1D49 101 \u1D4D 103 \u1D4F 107 \u1D50 109 \u1D52 111 \u1D56 112 \u1D57 116  \
    \u1D58 117 \u1D5B 118 \u1D62 105 \u1D63 114 \u1D64 117 \u1D65 118 \u1D6C 98 \u1D6D 100 \u1D6E 102 \u1D6F 109  \
    \u1D70 110 \u1D71 112 \u1D72 114 \u1D73 114 \u1D74 115 \u1D75 116 \u1D76 122 \u1D7B 73 \u1D7D 112 \u1D7E 85  \
    \u1D80 98 \u1D81 100 \u1D82 102 \u1D83 103 \u1D84 107 \u1D85 108 \u1D86 109 \u1D87 110 \u1D88 112 \u1D89 114  \
    \u1D8A 115 \u1D8C 118 \u1D8D 120 \u1D8E 122 \u1D8F 97 \u1D91 100 \u1D92 101 \u1D96 105 \u1D99 117 \u1D9C 99  \
    \u1D9D 99 \u1D9E 100 \u1D9F 101 \u1DA0 102 \u1DA1 106 \u1DA2 103 \u1DA3 104 \u1DA4 105 \u1DA6 105 \u1DA7 105  \
    \u1DA8 106 \u1DA9 108 \u1DAA 108 \u1DAB 108 \u1DAC 109 \u1DAD 109 \u1DAE 110 \u1DAF 110 \u1DB0 110 \u1DB1 111  \
    \u1DB3 115 \u1DB5 116 \u1DB6 117 \u1DB8 117 \u1DB9 118 \u1DBA 118 \u1DBB 122 \u1DBC 122 \u1DBD 122 \u1E00 65  \
    \u1E01 97 \u1E02 66 \u1E03 98 \u1E04 66 \u1E05 98 \u1E06 66 \u1E07 98 \u1E08 67 \u1E09 99 \u1E0A 68  \
    \u1E0B 100 \u1E0C 68 \u1E0D 100 \u1E0E 68 \u1E0F 100 \u1E10 68 \u1E11 100 \u1E12 68 \u1E13 100 \u1E14 69  \
    \u1E15 101 \u1E16 69 \u1E17 101 \u1E18 69 \u1E19 101 \u1E1A 69 \u1E1B 101 \u1E1C 69 \u1E1D 101 \u1E1E 70  \
    \u1E1F 102 \u1E20 71 \u1E21 103 \u1E22 72 \u1E23 104 \u1E24 72 \u1E25 104 \u1E26 72 \u1E27 104 \u1E28 72  \
    \u1E29 104 \u1E2A 72 \u1E2B 104 \u1E2C 73 \u1E2D 105 \u1E2E 73 \u1E2F 105 \u1E30 75 \u1E31 107 \u1E32 75  \
    \u1E33 107 \u1E34 75 \u1E35 107 \u1E36 76 \u1E37 108 \u1E38 76 \u1E39 108 \u1E3A 76 \u1E3B 108 \u1E3C 76  \
    \u1E3D 108 \u1E3E 77 \u1E3F 109 \u1E40 77 \u1E41 109 \u1E42 77 \u1E43 109 \u1E44 78 \u1E45 110 \u1E46 78  \
    \u1E47 110 \u1E48 78 \u1E49 110 \u1E4A 78 \u1E4B 110 \u1E4C 79 \u1E4D 111 \u1E4E 79 \u1E4F 111 \u1E50 79  \
    \u1E51 111 \u1E52 79 \u1E53 111 \u1E54 80 \u1E55 112 \u1E56 80 \u1E57 112 \u1E58 82 \u1E59 114 \u1E5A 82  \
    \u1E5B 114 \u1E5C 82 \u1E5D 114 \u1E5E 82 \u1E5F 114 \u1E60 83 \u1E61 115 \u1E62 83 \u1E63 115 \u1E64 83  \
    \u1E65 115 \u1E66 83 \u1E67 115 \u1E68 83 \u1E69 115 \u1E6A 84 \u1E6B 116 \u1E6C 84 \u1E6D 116 \u1E6E 84  \
    \u1E6F 116 \u1E70 84 \u1E71 116 \u1E72 85 \u1E73 117 \u1E74 85 \u1E75 117 \u1E76 85 \u1E77 117 \u1E78 85  \
    \u1E79 117 \u1E7A 85 \u1E7B 117 \u1E7C 86 \u1E7D 118 \u1E7E 86 \u1E7F 118 \u1E80 87 \u1E81 119 \u1E82 87  \
    \u1E83 119 \u1E84 87 \u1E85 119 \u1E86 87 \u1E87 119 \u1E88 87 \u1E89 119 \u1E8A 88 \u1E8B 120 \u1E8C 88  \
    \u1E8D 120 \u1E8E 89 \u1E8F 121 \u1E90 90 \u1E91 122 \u1E92 90 \u1E93 122 \u1E94 90 \u1E95 122 \u1E96 104  \
    \u1E97 116 \u1E98 119 \u1E99 121 \u1E9A 97 \u1E9B 115 \u1EA0 65 \u1EA1 97 \u1EA2 65 \u1EA3 97 \u1EA4 65  \
    \u1EA5 97 \u1EA6 65 \u1EA7 97 \u1EA8 65 \u1EA9 97 \u1EAA 65 \u1EAB 97 \u1EAC 65 \u1EAD 97 \u1EAE 65  \
    \u1EAF 97 \u1EB0 65 \u1EB1 97 \u1EB2 65 \u1EB3 97 \u1EB4 65 \u1EB5 97 \u1EB6 65 \u1EB7 97 \u1EB8 69  \
    \u1EB9 101 \u1EBA 69 \u1EBB 101 \u1EBC 69 \u1EBD 101 \u1EBE 69 \u1EBF 101 \u1EC0 69 \u1EC1 101 \u1EC2 69  \
    \u1EC3 101 \u1EC4 69 \u1EC5 101 \u1EC6 69 \u1EC7 101 \u1EC8 73 \u1EC9 105 \u1ECA 73 \u1ECB 105 \u1ECC 79  \
    \u1ECD 111 \u1ECE 79 \u1ECF 111 \u1ED0 79 \u1ED1 111 \u1ED2 79 \u1ED3 111 \u1ED4 79 \u1ED5 111 \u1ED6 79  \
    \u1ED7 111 \u1ED8 79 \u1ED9 111 \u1EDA 79 \u1EDB 111 \u1EDC 79 \u1EDD 111 \u1EDE 79 \u1EDF 111 \u1EE0 79  \
    \u1EE1 111 \u1EE2 79 \u1EE3 111 \u1EE4 85 \u1EE5 117 \u1EE6 85 \u1EE7 117 \u1EE8 85 \u1EE9 117 \u1EEA 85  \
    \u1EEB 117 \u1EEC 85 \u1EED 117 \u1EEE 85 \u1EEF 117 \u1EF0 85 \u1EF1 117 \u1EF2 89 \u1EF3 121 \u1EF4 89  \
    \u1EF5 121 \u1EF6 89 \u1EF7 121 \u1EF8 89 \u1EF9 121 \u1FBD 32 \u1FBF 32 \u1FC0 32 \u1FC1 32 \u1FCD 32  \
    \u1FCE 32 \u1FCF 32 \u1FDD 32 \u1FDE 32 \u1FDF 32 \u1FED 32 \u1FEE 32 \u1FEF 96 \u1FFD 32 \u1FFE 32  \
    \u2000 32 \u2001 32 \u2002 32 \u2003 32 \u2004 32 \u2005 32 \u2006 32 \u2007 32 \u2008 32 \u2009 32  \
    \u200A 32 \u2010 45 \u2011 45 \u2013 45 \u2014 45 \u2017 32 \u2018 39 \u2019 39 \u201A 39 \u201B 39  \
    \u201C 34 \u201D 34 \u201E 34 \u201F 34 \u2024 46 \u202F 32 \u203C 33 \u203E 32 \u2043 45 \u2047 63  \
    \u2048 33 \u2052 45 \u205F 32 \u2070 48 \u2071 105 \u2074 52 \u2075 53 \u2076 54 \u2077 55 \u2078 56  \
    \u2079 57 \u207A 43 \u207B 173 \u207C 61 \u207D 40 \u207E 41 \u207F 110 \u2080 48 \u2081 49 \u2082 50  \
    \u2083 51 \u2084 52 \u2085 53 \u2086 54 \u2087 55 \u2088 56 \u2089 57 \u208A 43 \u208B 173 \u208C 61  \
    \u208D 40 \u208E 41 \u2090 97 \u2091 101 \u2092 111 \u2093 120 \u2102 67 \u210A 103 \u210B 72 \u210C 72  \
    \u210D 72 \u210E 104 \u2110 73 \u2111 73 \u2112 76 \u2113 108 \u2115 78 \u2119 80 \u211A 81 \u211B 82  \
    \u211C 82 \u211D 82 \u2124 90 \u2128 90 \u212A 75 \u212B 65 \u212C 66 \u212D 67 \u212F 101 \u2130 69  \
    \u2131 70 \u2133 77 \u2134 111 \u2139 105 \u2145 68 \u2146 100 \u2147 101 \u2148 105 \u2149 106 \u215F 49  \
    \u2160 73 \u2164 86 \u2169 88 \u216C 76 \u216D 67 \u216E 68 \u216F 77 \u2170 105 \u2174 118 \u2179 120  \
    \u217C 108 \u217D 99 \u217E 100 \u217F 109 \u2212 45 \u2215 47 \u2260 61 \u226E 60 \u226F 62 \u228D 42  \
    \u2296 45 \u2298 47 \u229F 45 \u2310 172 \u2319 172 \u2460 49 \u2461 50 \u2462 51 \u2463 52 \u2464 53  \
    \u2465 54 \u2466 55 \u2467 56 \u2468 57 \u2474 49 \u2475 50 \u2476 51 \u2477 52 \u2478 53 \u2479 54  \
    \u247A 55 \u247B 56 \u247C 57 \u2488 49 \u2489 50 \u248A 51 \u248B 52 \u248C 53 \u248D 54 \u248E 55  \
    \u248F 56 \u2490 57 \u249C 97 \u249D 98 \u249E 99 \u249F 100 \u24A0 101 \u24A1 102 \u24A2 103 \u24A3 104  \
    \u24A4 105 \u24A5 106 \u24A6 107 \u24A7 108 \u24A8 109 \u24A9 110 \u24AA 111 \u24AB 112 \u24AC 113 \u24AD 114  \
    \u24AE 115 \u24AF 116 \u24B0 117 \u24B1 118 \u24B2 119 \u24B3 120 \u24B4 121 \u24B5 122 \u24B6 65 \u24B7 66  \
    \u24B8 67 \u24B9 68 \u24BA 69 \u24BB 70 \u24BC 71 \u24BD 72 \u24BE 73 \u24BF 74 \u24C0 75 \u24C1 76  \
    \u24C2 77 \u24C3 78 \u24C4 79 \u24C5 80 \u24C6 81 \u24C7 82 \u24C8 83 \u24C9 84 \u24CA 85 \u24CB 86  \
    \u24CC 87 \u24CD 88 \u24CE 89 \u24CF 90 \u24D0 97 \u24D1 98 \u24D2 99 \u24D3 100 \u24D4 101 \u24D5 102  \
    \u24D6 103 \u24D7 104 \u24D8 105 \u24D9 106 \u24DA 107 \u24DB 108 \u24DC 109 \u24DD 110 \u24DE 111 \u24DF 112  \
    \u24E0 113 \u24E1 114 \u24E2 115 \u24E3 116 \u24E4 117 \u24E5 118 \u24E6 119 \u24E7 120 \u24E8 121 \u24E9 122  \
    \u24EA 48 \u24F5 49 \u24F6 50 \u24F7 51 \u24F8 52 \u24F9 53 \u24FA 54 \u24FB 55 \u24FC 56 \u24FD 57  \
    \u24FF 48 \u2715 42 \u2716 42 \u2762 33 \u2763 33 \u2776 49 \u2777 50 \u2778 51 \u2779 52 \u277A 53  \
    \u277B 54 \u277C 55 \u277D 56 \u277E 57 \u2780 49 \u2781 50 \u2782 51 \u2783 52 \u2784 53 \u2785 54  \
    \u2786 55 \u2787 56 \u2788 57 \u278A 49 \u278B 50 \u278C 51 \u278D 52 \u278E 53 \u278F 54 \u2790 55  \
    \u2791 56 \u2792 57 \u2A30 42 \u2A31 42 \u2A34 42 \u2A35 42 \u2A36 42 \u2A37 42 \u2A38 47 \u2A3B 42  \
    \u2AC1 42 \u2AC2 42 \u2AEC 172 \u2AED 172 \u2C0B 73 \u2C3B 105 \u2C60 76 \u2C61 108 \u2C62 76 \u2C63 80  \
    \u2C64 82 \u2C65 97 \u2C66 116 \u2C67 72 \u2C68 104 \u2C69 75 \u2C6A 107 \u2C6B 90 \u2C6C 122 \u2C74 118  \
    \u2C7C 106 \u2C7D 86 \u2C9E 79 \u2C9F 111 \u2CFA 63 \u2CFB 63 \u3000 32 \u3001 44 \u3002 46 \u309B 32  \
    \u309C 32 \u32C0 49 \u32C1 50 \u32C2 51 \u32C3 52 \u32C4 53 \u32C5 54 \u32C6 55 \u32C7 56 \u32C8 57  \
    \u3358 48 \u3359 49 \u335A 50 \u335B 51 \u335C 52 \u335D 53 \u335E 54 \u335F 55 \u3360 56 \u3361 57  \
    \u33C0 107 \u33C1 77 \u33E0 49 \u33E1 50 \u33E2 51 \u33E3 52 \u33E4 53 \u33E5 54 \u33E6 55 \u33E7 56  \
    \u33E8 57 \uFB29 43 \uFC5E 32 \uFC5F 32 \uFC60 32 \uFC61 32 \uFC62 32 \uFC63 32 \uFE10 44 \uFE13 58  \
    \uFE14 59 \uFE15 33 \uFE16 63 \uFE33 95 \uFE34 95 \uFE35 40 \uFE36 41 \uFE37 123 \uFE38 125 \uFE47 91  \
    \uFE48 93 \uFE49 32 \uFE4A 32 \uFE4B 32 \uFE4C 32 \uFE4D 95 \uFE4E 95 \uFE4F 95 \uFE50 44 \uFE52 46  \
    \uFE54 59 \uFE55 58 \uFE56 63 \uFE57 33 \uFE59 40 \uFE5A 41 \uFE5B 123 \uFE5C 125 \uFE5F 35 \uFE60 38  \
    \uFE61 42 \uFE62 43 \uFE63 45 \uFE64 60 \uFE65 62 \uFE66 61 \uFE68 92 \uFE69 36 \uFE6A 37 \uFE6B 64  \
    \uFE70 32 \uFE72 32 \uFE74 32 \uFE76 32 \uFE78 32 \uFE7A 32 \uFE7C 32 \uFE7E 32 \uFF01 33 \uFF02 34  \
    \uFF03 35 \uFF04 36 \uFF05 37 \uFF06 38 \uFF07 39 \uFF08 40 \uFF09 41 \uFF0A 42 \uFF0B 43 \uFF0C 44  \
    \uFF0D 45 \uFF0E 46 \uFF0F 47 \uFF10 48 \uFF11 49 \uFF12 50 \uFF13 51 \uFF14 52 \uFF15 53 \uFF16 54  \
    \uFF17 55 \uFF18 56 \uFF19 57 \uFF1A 58 \uFF1B 59 \uFF1C 60 \uFF1D 61 \uFF1E 62 \uFF1F 63 \uFF20 64  \
    \uFF21 65 \uFF22 66 \uFF23 67 \uFF24 68 \uFF25 69 \uFF26 70 \uFF27 71 \uFF28 72 \uFF29 73 \uFF2A 74  \
    \uFF2B 75 \uFF2C 76 \uFF2D 77 \uFF2E 78 \uFF2F 79 \uFF30 80 \uFF31 81 \uFF32 82 \uFF33 83 \uFF34 84  \
    \uFF35 85 \uFF36 86 \uFF37 87 \uFF38 88 \uFF39 89 \uFF3A 90 \uFF3B 91 \uFF3C 92 \uFF3D 93 \uFF3E 94  \
    \uFF3F 95 \uFF40 96 \uFF41 97 \uFF42 98 \uFF43 99 \uFF44 100 \uFF45 101 \uFF46 102 \uFF47 103 \uFF48 104  \
    \uFF49 105 \uFF4A 106 \uFF4B 107 \uFF4C 108 \uFF4D 109 \uFF4E 110 \uFF4F 111 \uFF50 112 \uFF51 113 \uFF52 114  \
    \uFF53 115 \uFF54 116 \uFF55 117 \uFF56 118 \uFF57 119 \uFF58 120 \uFF59 121 \uFF5A 122 \uFF5B 123 \uFF5C 124  \
    \uFF5D 125 \uFF5E 126 \uFFE0 162 \uFFE1 163 \uFFE2 172 \uFFE3 32 \uFFE4 166 \uFFE5 165 \u10410 72 \u1041B 208  \
    \u10438 104 \u10443 240 \u104A0 48 \u104A1 49 \u104A2 50 \u104A3 51 \u104A4 52 \u104A5 53 \u104A6 54 \u104A7 55  \
    \u104A8 56 \u104A9 57 \u10A40 49 \u10A41 50 \u10A42 51 \u10A43 52 \u1D360 49 \u1D361 50 \u1D362 51 \u1D363 52  \
    \u1D364 53 \u1D365 54 \u1D366 55 \u1D367 56 \u1D368 57 \u1D369 49 \u1D36A 50 \u1D36B 51 \u1D36C 52 \u1D36D 53  \
    \u1D36E 54 \u1D36F 55 \u1D370 56 \u1D371 57 \u1D400 65 \u1D401 66 \u1D402 67 \u1D403 68 \u1D404 69 \u1D405 70  \
    \u1D406 71 \u1D407 72 \u1D408 73 \u1D409 74 \u1D40A 75 \u1D40B 76 \u1D40C 77 \u1D40D 78 \u1D40E 79 \u1D40F 80  \
    \u1D410 81 \u1D411 82 \u1D412 83 \u1D413 84 \u1D414 85 \u1D415 86 \u1D416 87 \u1D417 88 \u1D418 89 \u1D419 90  \
    \u1D41A 97 \u1D41B 98 \u1D41C 99 \u1D41D 100 \u1D41E 101 \u1D41F 102 \u1D420 103 \u1D421 104 \u1D422 105 \u1D423 106  \
    \u1D424 107 \u1D425 108 \u1D426 109 \u1D427 110 \u1D428 111 \u1D429 112 \u1D42A 113 \u1D42B 114 \u1D42C 115 \u1D42D 116  \
    \u1D42E 117 \u1D42F 118 \u1D430 119 \u1D431 120 \u1D432 121 \u1D433 122 \u1D434 65 \u1D435 66 \u1D436 67 \u1D437 68  \
    \u1D438 69 \u1D439 70 \u1D43A 71 \u1D43B 72 \u1D43C 73 \u1D43D 74 \u1D43E 75 \u1D43F 76 \u1D440 77 \u1D441 78  \
    \u1D442 79 \u1D443 80 \u1D444 81 \u1D445 82 \u1D446 83 \u1D447 84 \u1D448 85 \u1D449 86 \u1D44A 87 \u1D44B 88  \
    \u1D44C 89 \u1D44D 90 \u1D44E 97 \u1D44F 98 \u1D450 99 \u1D451 100 \u1D452 101 \u1D453 102 \u1D454 103 \u1D456 105  \
    \u1D457 106 \u1D458 107 \u1D459 108 \u1D45A 109 \u1D45B 110 \u1D45C 111 \u1D45D 112 \u1D45E 113 \u1D45F 114 \u1D460 115  \
    \u1D461 116 \u1D462 117 \u1D463 118 \u1D464 119 \u1D465 120 \u1D466 121 \u1D467 122 \u1D468 65 \u1D469 66 \u1D46A 67  \
    \u1D46B 68 \u1D46C 69 \u1D46D 70 \u1D46E 71 \u1D46F 72 \u1D470 73 \u1D471 74 \u1D472 75 \u1D473 76 \u1D474 77  \
    \u1D475 78 \u1D476 79 \u1D477 80 \u1D478 81 \u1D479 82 \u1D47A 83 \u1D47B 84 \u1D47C 85 \u1D47D 86 \u1D47E 87  \
    \u1D47F 88 \u1D480 89 \u1D481 90 \u1D482 97 \u1D483 98 \u1D484 99 \u1D485 100 \u1D486 101 \u1D487 102 \u1D488 103  \
    \u1D489 104 \u1D48A 105 \u1D48B 106 \u1D48C 107 \u1D48D 108 \u1D48E 109 \u1D48F 110 \u1D490 111 \u1D491 112 \u1D492 113  \
    \u1D493 114 \u1D494 115 \u1D495 116 \u1D496 117 \u1D497 118 \u1D498 119 \u1D499 120 \u1D49A 121 \u1D49B 122 \u1D49C 65  \
    \u1D49E 67 \u1D49F 68 \u1D4A2 71 \u1D4A5 74 \u1D4A6 75 \u1D4A9 78 \u1D4AA 79 \u1D4AB 80 \u1D4AC 81 \u1D4AE 83  \
    \u1D4AF 84 \u1D4B0 85 \u1D4B1 86 \u1D4B2 87 \u1D4B3 88 \u1D4B4 89 \u1D4B5 90 \u1D4B6 97 \u1D4B7 98 \u1D4B8 99  \
    \u1D4B9 100 \u1D4BB 102 \u1D4BD 104 \u1D4BE 105 \u1D4BF 106 \u1D4C0 107 \u1D4C1 108 \u1D4C2 109 \u1D4C3 110 \u1D4C5 112  \
    \u1D4C6 113 \u1D4C7 114 \u1D4C8 115 \u1D4C9 116 \u1D4CA 117 \u1D4CB 118 \u1D4CC 119 \u1D4CD 120 \u1D4CE 121 \u1D4CF 122  \
    \u1D4D0 65 \u1D4D1 66 \u1D4D2 67 \u1D4D3 68 \u1D4D4 69 \u1D4D5 70 \u1D4D6 71 \u1D4D7 72 \u1D4D8 73 \u1D4D9 74  \
    \u1D4DA 75 \u1D4DB 76 \u1D4DC 77 \u1D4DD 78 \u1D4DE 79 \u1D4DF 80 \u1D4E0 81 \u1D4E1 82 \u1D4E2 83 \u1D4E3 84  \
    \u1D4E4 85 \u1D4E5 86 \u1D4E6 87 \u1D4E7 88 \u1D4E8 89 \u1D4E9 90 \u1D4EA 97 \u1D4EB 98 \u1D4EC 99 \u1D4ED 100  \
    \u1D4EE 101 \u1D4EF 102 \u1D4F0 103 \u1D4F1 104 \u1D4F2 105 \u1D4F3 106 \u1D4F4 107 \u1D4F5 108 \u1D4F6 109 \u1D4F7 110  \
    \u1D4F8 111 \u1D4F9 112 \u1D4FA 113 \u1D4FB 114 \u1D4FC 115 \u1D4FD 116 \u1D4FE 117 \u1D4FF 118 \u1D500 119 \u1D501 120  \
    \u1D502 121 \u1D503 122 \u1D504 65 \u1D505 66 \u1D507 68 \u1D508 69 \u1D509 70 \u1D50A 71 \u1D50D 74 \u1D50E 75  \
    \u1D50F 76 \u1D510 77 \u1D511 78 \u1D512 79 \u1D513 80 \u1D514 81 \u1D516 83 \u1D517 84 \u1D518 85 \u1D519 86  \
    \u1D51A 87 \u1D51B 88 \u1D51C 89 \u1D51E 97 \u1D51F 98 \u1D520 99 \u1D521 100 \u1D522 101 \u1D523 102 \u1D524 103  \
    \u1D525 104 \u1D526 105 \u1D527 106 \u1D528 107 \u1D529 108 \u1D52A 109 \u1D52B 110 \u1D52C 111 \u1D52D 112 \u1D52E 113  \
    \u1D52F 114 \u1D530 115 \u1D531 116 \u1D532 117 \u1D533 118 \u1D534 119 \u1D535 120 \u1D536 121 \u1D537 122 \u1D538 65  \
    \u1D539 66 \u1D53B 68 \u1D53C 69 \u1D53D 70 \u1D53E 71 \u1D540 73 \u1D541 74 \u1D542 75 \u1D543 76 \u1D544 77  \
    \u1D546 79 \u1D54A 83 \u1D54B 84 \u1D54C 85 \u1D54D 86 \u1D54E 87 \u1D54F 88 \u1D550 89 \u1D552 97 \u1D553 98  \
    \u1D554 99 \u1D555 100 \u1D556 101 \u1D557 102 \u1D558 103 \u1D559 104 \u1D55A 105 \u1D55B 106 \u1D55C 107 \u1D55D 108  \
    \u1D55E 109 \u1D55F 110 \u1D560 111 \u1D561 112 \u1D562 113 \u1D563 114 \u1D564 115 \u1D565 116 \u1D566 117 \u1D567 118  \
    \u1D568 119 \u1D569 120 \u1D56A 121 \u1D56B 122 \u1D56C 65 \u1D56D 66 \u1D56E 67 \u1D56F 68 \u1D570 69 \u1D571 70  \
    \u1D572 71 \u1D573 72 \u1D574 73 \u1D575 74 \u1D576 75 \u1D577 76 \u1D578 77 \u1D579 78 \u1D57A 79 \u1D57B 80  \
    \u1D57C 81 \u1D57D 82 \u1D57E 83 \u1D57F 84 \u1D580 85 \u1D581 86 \u1D582 87 \u1D583 88 \u1D584 89 \u1D585 90  \
    \u1D586 97 \u1D587 98 \u1D588 99 \u1D589 100 \u1D58A 101 \u1D58B 102 \u1D58C 103 \u1D58D 104 \u1D58E 105 \u1D58F 106  \
    \u1D590 107 \u1D591 108 \u1D592 109 \u1D593 110 \u1D594 111 \u1D595 112 \u1D596 113 \u1D597 114 \u1D598 115 \u1D599 116  \
    \u1D59A 117 \u1D59B 118 \u1D59C 119 \u1D59D 120 \u1D59E 121 \u1D59F 122 \u1D5A0 65 \u1D5A1 66 \u1D5A2 67 \u1D5A3 68  \
    \u1D5A4 69 \u1D5A5 70 \u1D5A6 71 \u1D5A7 72 \u1D5A8 73 \u1D5A9 74 \u1D5AA 75 \u1D5AB 76 \u1D5AC 77 \u1D5AD 78  \
    \u1D5AE 79 \u1D5AF 80 \u1D5B0 81 \u1D5B1 82 \u1D5B2 83 \u1D5B3 84 \u1D5B4 85 \u1D5B5 86 \u1D5B6 87 \u1D5B7 88  \
    \u1D5B8 89 \u1D5B9 90 \u1D5BA 97 \u1D5BB 98 \u1D5BC 99 \u1D5BD 100 \u1D5BE 101 \u1D5BF 102 \u1D5C0 103 \u1D5C1 104  \
    \u1D5C2 105 \u1D5C3 106 \u1D5C4 107 \u1D5C5 108 \u1D5C6 109 \u1D5C7 110 \u1D5C8 111 \u1D5C9 112 \u1D5CA 113 \u1D5CB 114  \
    \u1D5CC 115 \u1D5CD 116 \u1D5CE 117 \u1D5CF 118 \u1D5D0 119 \u1D5D1 120 \u1D5D2 121 \u1D5D3 122 \u1D5D4 65 \u1D5D5 66  \
    \u1D5D6 67 \u1D5D7 68 \u1D5D8 69 \u1D5D9 70 \u1D5DA 71 \u1D5DB 72 \u1D5DC 73 \u1D5DD 74 \u1D5DE 75 \u1D5DF 76  \
    \u1D5E0 77 \u1D5E1 78 \u1D5E2 79 \u1D5E3 80 \u1D5E4 81 \u1D5E5 82 \u1D5E6 83 \u1D5E7 84 \u1D5E8 85 \u1D5E9 86  \
    \u1D5EA 87 \u1D5EB 88 \u1D5EC 89 \u1D5ED 90 \u1D5EE 97 \u1D5EF 98 \u1D5F0 99 \u1D5F1 100 \u1D5F2 101 \u1D5F3 102  \
    \u1D5F4 103 \u1D5F5 104 \u1D5F6 105 \u1D5F7 106 \u1D5F8 107 \u1D5F9 108 \u1D5FA 109 \u1D5FB 110 \u1D5FC 111 \u1D5FD 112  \
    \u1D5FE 113 \u1D5FF 114 \u1D600 115 \u1D601 116 \u1D602 117 \u1D603 118 \u1D604 119 \u1D605 120 \u1D606 121 \u1D607 122  \
    \u1D608 65 \u1D609 66 \u1D60A 67 \u1D60B 68 \u1D60C 69 \u1D60D 70 \u1D60E 71 \u1D60F 72 \u1D610 73 \u1D611 74  \
    \u1D612 75 \u1D613 76 \u1D614 77 \u1D615 78 \u1D616 79 \u1D617 80 \u1D618 81 \u1D619 82 \u1D61A 83 \u1D61B 84  \
    \u1D61C 85 \u1D61D 86 \u1D61E 87 \u1D61F 88 \u1D620 89 \u1D621 90 \u1D622 97 \u1D623 98 \u1D624 99 \u1D625 100  \
    \u1D626 101 \u1D627 102 \u1D628 103 \u1D629 104 \u1D62A 105 \u1D62B 106 \u1D62C 107 \u1D62D 108 \u1D62E 109 \u1D62F 110  \
    \u1D630 111 \u1D631 112 \u1D632 113 \u1D633 114 \u1D634 115 \u1D635 116 \u1D636 117 \u1D637 118 \u1D638 119 \u1D639 120  \
    \u1D63A 121 \u1D63B 122 \u1D63C 65 \u1D63D 66 \u1D63E 67 \u1D63F 68 \u1D640 69 \u1D641 70 \u1D642 71 \u1D643 72  \
    \u1D644 73 \u1D645 74 \u1D646 75 \u1D647 76 \u1D648 77 \u1D649 78 \u1D64A 79 \u1D64B 80 \u1D64C 81 \u1D64D 82  \
    \u1D64E 83 \u1D64F 84 \u1D650 85 \u1D651 86 \u1D652 87 \u1D653 88 \u1D654 89 \u1D655 90 \u1D656 97 \u1D657 98  \
    \u1D658 99 \u1D659 100 \u1D65A 101 \u1D65B 102 \u1D65C 103 \u1D65D 104 \u1D65E 105 \u1D65F 106 \u1D660 107 \u1D661 108  \
    \u1D662 109 \u1D663 110 \u1D664 111 \u1D665 112 \u1D666 113 \u1D667 114 \u1D668 115 \u1D669 116 \u1D66A 117 \u1D66B 118  \
    \u1D66C 119 \u1D66D 120 \u1D66E 121 \u1D66F 122 \u1D670 65 \u1D671 66 \u1D672 67 \u1D673 68 \u1D674 69 \u1D675 70  \
    \u1D676 71 \u1D677 72 \u1D678 73 \u1D679 74 \u1D67A 75 \u1D67B 76 \u1D67C 77 \u1D67D 78 \u1D67E 79 \u1D67F 80  \
    \u1D680 81 \u1D681 82 \u1D682 83 \u1D683 84 \u1D684 85 \u1D685 86 \u1D686 87 \u1D687 88 \u1D688 89 \u1D689 90  \
    \u1D68A 97 \u1D68B 98 \u1D68C 99 \u1D68D 100 \u1D68E 101 \u1D68F 102 \u1D690 103 \u1D691 104 \u1D692 105 \u1D693 106  \
    \u1D694 107 \u1D695 108 \u1D696 109 \u1D697 110 \u1D698 111 \u1D699 112 \u1D69A 113 \u1D69B 114 \u1D69C 115 \u1D69D 116  \
    \u1D69E 117 \u1D69F 118 \u1D6A0 119 \u1D6A1 120 \u1D6A2 121 \u1D6A3 122 \u1D7CE 48 \u1D7CF 49 \u1D7D0 50 \u1D7D1 51  \
    \u1D7D2 52 \u1D7D3 53 \u1D7D4 54 \u1D7D5 55 \u1D7D6 56 \u1D7D7 57 \u1D7D8 48 \u1D7D9 49 \u1D7DA 50 \u1D7DB 51  \
    \u1D7DC 52 \u1D7DD 53 \u1D7DE 54 \u1D7DF 55 \u1D7E0 56 \u1D7E1 57 \u1D7E2 48 \u1D7E3 49 \u1D7E4 50 \u1D7E5 51  \
    \u1D7E6 52 \u1D7E7 53 \u1D7E8 54 \u1D7E9 55 \u1D7EA 56 \u1D7EB 57 \u1D7EC 48 \u1D7ED 49 \u1D7EE 50 \u1D7EF 51  \
    \u1D7F0 52 \u1D7F1 53 \u1D7F2 54 \u1D7F3 55 \u1D7F4 56 \u1D7F5 57 \u1D7F6 48 \u1D7F7 49 \u1D7F8 50 \u1D7F9 51  \
    \u1D7FA 52 \u1D7FB 53 \u1D7FC 54 \u1D7FD 55 \u1D7FE 56 \u1D7FF 57   ]

  unset -nocomplain enc
  foreach {x y} $unicode_to_latin1 {
    lappend enc(unicode_to_latin1) $x [format %c $y]
  }

  return;
};# ::potato::unicode-to-latin_init

::potato::unicode-to-latin1_init
